draw_set_font(global.font_main);

// Dynamically calculate the menu width and height
var _new_w = 0;
for (var i = 0; i < array_length(option[menu_level]); i++) { // Use array_length directly
    var _op_w = string_width(option[menu_level][i]);
    _new_w = max(_new_w, _op_w);
}
width = _new_w + op_border * 2;
height = op_border * 2 + string_height(option[menu_level][0]) + (op_length - 1) * op_space;

// Center the menu horizontally
x = camera_get_view_x(view_camera[0]) + camera_get_view_width(view_camera[0]) / 2 - width / 2;
y = camera_get_view_y(view_camera[0]) + camera_get_view_height(view_camera[0]) / 2 - height / 2;

// Draw the menu background with a sprite
draw_sprite_ext(sprite_index, image_index, x, y, width / sprite_width, height / sprite_height, 0, c_white, 1);

// Draw the options
draw_set_valign(fa_top);
draw_set_halign(fa_left);
for (var i = 0; i < array_length(option[menu_level]); i++) { // Use array_length directly
    var _c = (pos == i) ? c_yellow : c_white;
    var display_text = option[menu_level][i];

    // Adjust Fullscreen toggle text dynamically
    if (menu_level == 2 && i == 1) {
        display_text = "Window mode: " + (global.fullscreen_enabled ? "Fullscreen" : "Windowed");
    }

    draw_text_color(x + op_border, y + op_border + op_space * i, display_text, _c, _c, _c, _c, 1);
}
